// File: int_vect.cp
//
// Description: This file implements the smart smart vector
//              class using C++ templates.
//
// Copyright 1992, 1994 by Mark Watson Associates
//
//       No binary rights reserved: this software library may
//       be used in compiled form without restrictions.  All
//       source rights reserved: Source code to the GUI library
//       can not be distributed (on bulletin boards, or as part
//       of shareware or commercial products) without written
//       permission.
//

#include "smart_v.h"
#include <iostream.h>
#include <fstream.h>

extern "C" { void exit(int); };

extern void Warning(char *);

// Define constants for the dynamic grow rate for vect data types and
// the maximum number of elements that a smart vect can have:

const int GROW_RATE = 1;
const int MAX_SIZE = 5000;

template<class T>
vect<T>::vect(void)
{
	num_elements = 0;
	size = 10;
	p = new T[size];
}

template<class T>
vect<T>::vect(int n)
{
	if (n<= 0) {
		Warning("illegal size for a vect");
		exit(1);
	}
	num_elements = 0;
	size = n;
	p = new T[size];
}

template<class T>
vect<T>::vect(T a[], int n)
{
	if (n<= 0) {
		Warning("illegal size for a vect");
		exit(1);
	}
	num_elements = size = n;
	p = new T[size];
	for (int i=0; i<size; i++)  p[i] = a[i];
}

template<class T>
vect<T>::vect(vect &v)
{
	size = v.size;
	p = new T[size];
	for (int i=0; i<size; i++)  p[i] = v.p[i];
	num_elements = size;
}

template<class T>
T & vect<T>::operator [] (int i)
{
	if (i < 0) {
		Warning("illegal index for vect");
		exit(1);
	}
	if (i > ub()) {
		grow(i);
	}
	if ((i + 1) > num_elements)  num_elements = i+1;
	return (p[i]);
}

template<class T>
void vect<T>::grow(int new_size)
{
	if ((new_size + GROW_RATE) >= MAX_SIZE) {
		Warning("error in dynamic resizing of a smart vect");
		exit(1);
	}
	T *np = new T[(new_size + GROW_RATE)];
	for (int i=0; i<size; i++)  np[i] = p[i];
	delete p;
	size = (new_size + GROW_RATE);
	p = np;
}

template<class T>
void vect<T>::save(char *file_name)
{
	filebuf out_file;
	if (out_file.open(file_name, output)==0) {
		Warning("Could not open output file for int vect save");
		exit(1);
	}
	ostream out_stream(&out_file);
	out_stream << num_elements << "\n";
	for (int i=0; i<num_elements; i++)
		out_stream << p[i] << "\n";
	out_file.close();
}

template<class T>
void vect<T>::restore(char *file_name)
{
	filebuf in_file;
	if (in_file.open(file_name, input)==0) {
		Warning("Could not open input file for int vect restore");
		exit(1);
	}
	istream in_stream(&in_file);
	in_stream >> size;
	num_elements = size;

	if (size > ub()-1)  grow(size);
	for (int i=0; i<num_elements; i++)
		in_stream >> p[i];
	in_file.close();
}

#if 1

// test code:

void Warning(char *str)
{
    cerr << str << "\n";
}

main()
{
	cerr << "Start of vect test using templates:\n\n";

	vect<int> iv(10);
	iv[2] = 2;
	iv[220] = iv[2];  // illegal index !!
    cerr << iv[220] << "\n";

	vect<double> dv(10);
	dv[2] = 2;
	dv[220] = dv[2];  // illegal index !!
    cerr << dv[220] << "\n";
	cerr << "Done with test.\n";
}

#endif
